<?php
// student_login.php
session_start();
require_once 'config.php'; // provides $dbh (PDO)

// If already logged in redirect
if (!empty($_SESSION['student_id'])) {
    header('Location: student_dashboard.php');
    exit;
}

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $admission = trim($_POST['admission'] ?? '');
    $dob = trim($_POST['dob'] ?? ''); // expect YYYY-MM-DD from date input
    if (!$admission || !$dob) {
        $err = "Please enter admission number and date of birth.";
    } else {
        $stmt = $dbh->prepare("SELECT * FROM students WHERE Admission_num = :admission AND dob = :dob AND status = 'active' LIMIT 1");
        $stmt->execute([':admission' => $admission, ':dob' => $dob]);
        $student = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($student) {
            // create session
            $_SESSION['student_id'] = $student['id'];
            $_SESSION['student_name'] = $student['name'];
            $_SESSION['student_class_id'] = $student['class_id'];
            header('Location: student_dashboard.php');
            exit;
        } else {
            $err = "Student not found or incorrect credentials.";
        }
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title>Student Login</title>
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <style>
    /* Minimal Tailwind-like utilities used below; replace with actual Tailwind if available */
    :root{ --bg:#f7fafc; --panel:#ffffff; --muted:#6b7280; --accent:#0ea5a4; }
    body{font-family:Inter,system-ui,-apple-system,Segoe UI,Roboto,"Helvetica Neue",Arial;margin:0;background:var(--bg);color:#111;}
    .container{max-width:920px;margin:40px auto;padding:20px;}
    .card{background:var(--panel);border-radius:12px;padding:22px;box-shadow:0 6px 18px rgba(16,24,40,0.06);}
    .input{width:100%;padding:10px;border-radius:8px;border:1px solid #e6e9ee;margin-top:6px;}
    .btn{display:inline-block;padding:10px 16px;border-radius:8px;background:var(--accent);color:#fff;border:none;cursor:pointer;}
    .muted{color:var(--muted);}
  </style>
</head>
<body>
  <div class="container">
    <div class="card">
      <h2 style="margin:0 0 6px">Student Login</h2>
      <p class="muted" style="margin:0 0 16px">Sign in with admission number and date of birth.</p>

      <?php if($err): ?>
        <div style="color:#b91c1c;margin-bottom:12px"><?=htmlspecialchars($err)?></div>
      <?php endif; ?>

      <form method="post">
        <label>Admission number
          <input class="input" name="admission" placeholder="" value="<?=htmlspecialchars($_POST['admission'] ?? '')?>">
        </label>
        <label style="display:block;margin-top:10px">Date of birth
          <input class="input" type="date" name="dob" value="<?=htmlspecialchars($_POST['dob'] ?? '')?>">
        </label>

        <div style="margin-top:14px">
          <button class="btn">Login</button>
        </div>
      </form>
    </div>
  </div>
</body>
</html>
