<?php     include 'config.php'; ?>
<?php

if(isset($_POST['insert']))
  {
$subject_name = $_POST['subject'];
$question_text = $_POST['question'];
$answer = $_POST['answer'];

// Check if subject already exists
$sql = "SELECT id FROM subjects WHERE name=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $subject_name);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    $stmt = $conn->prepare("INSERT INTO subjects (name) VALUES (?)");
    $stmt->bind_param('s', $subject_name);
    $stmt->execute();
    $subject_id = $stmt->insert_id;
} else {
    $row = $result->fetch_assoc();
    $subject_id = $row['id'];
}

// Insert question
$stmt = $conn->prepare("INSERT INTO questions (subject_id, question_text, answer) VALUES (?, ?, ?)");
$stmt->bind_param('iss', $subject_id, $question_text, $answer);
$stmt->execute();

echo "Question added successfully.";
//$conn->close();
}
?>

<?php

$sql = "SELECT questions.id, questions.question_text FROM questions";
$result = $conn->query($sql);

$questions = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $questions[] = $row;
    }
}

echo json_encode($questions);
$conn->close();
?>



<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Objective E Exam</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
    font-family: Arial, sans-serif;
    margin: 20px;
}

#exam-container {
    max-width: 600px;
    margin: auto;
}

#timer {
    margin-bottom: 20px;
    font-weight: bold;
}

#result {
    margin-top: 20px;
    font-size: 20px;
    color: green;
}
    </style>
</head>
<body>
    
    
        <h1>Examiner Dashboard</h1>
    <form action="" method="post">
        <label for="subject">Subject:</label>
        <input type="text" name="subject" id="subject" required><br>
        
        <label for="question">Question:</label>
        <textarea name="question" id="question" required></textarea><br>
        
        <label for="answer">Correct Answer:</label>
        <input type="text" name="answer" id="answer" required><br>
        
        <input type="submit" name="insert" value="Add Question">
    </form>
    
    
    
    
    
    <div id="exam-container">
        <h1>Objective E Exam</h1>
        <form id="exam-form">
            <!-- Questions will be inserted here by JavaScript -->
            <input type="submit" value="Submit Exam">
        </form>
        <div id="timer">Time Remaining: <span id="time"></span></div>
        <div id="result"></div>
    </div>
    <script >
        document.addEventListener("DOMContentLoaded", function () {
    const form = document.getElementById('exam-form');
    const timeDisplay = document.getElementById('time');
    const resultDisplay = document.getElementById('result');

    let timeLimit = 300; // Example: 5 minutes
    let timer = setInterval(updateTimer, 1000);

    function updateTimer() {
        if (timeLimit <= 0) {
            clearInterval(timer);
            form.submit();
            return;
        }
        timeLimit--;
        let minutes = Math.floor(timeLimit / 60);
        let seconds = timeLimit % 60;
        timeDisplay.textContent = `${minutes}:${seconds < 10 ? '0' + seconds : seconds}`;
    }

    form.addEventListener('submit', function (event) {
        event.preventDefault();
        clearInterval(timer);
        // Here send the data to the server and calculate the result
        // Simulating result:
        resultDisplay.textContent = "Your score is: 80";
    });

    loadQuestions();

    function loadQuestions() {
        // Use AJAX to load questions from the server
        // Example placeholder (actual questions should be fetched from server):
        
        form.innerHTML = `
            <div>
                <p>Question 1: What is 2 + 2?</p>
                <input type="radio" name="q1" value="3"> 3<br>
                <input type="radio" name="q1" value="4"> 4<br>
            </div>
            <div>
                <p>Question 2: What is 3 + 3?</p>
                <input type="radio" name="q2" value="5"> 5<br>
                <input type="radio" name="q2" value="6"> 6<br>
            </div>
        `;
    }
});
    </script>
    
    
    
    
    
    
    
    
</body>






</html>