<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />

    <title>Student Promotion</title>
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">
<?php


// Fetch all classes to populate the dropdown
$query = "SELECT * FROM classes";
$stmt = $dbh->query($query);
$classes = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>


<div class="wrapper">

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <h1>Student Promotion</h1>
            <h5>Note that you should promote students from the highest class down to the lowest class</h5>

            <!-- Current Class Selection Dropdown -->
            <div class="form-group">
                <label for="current_class_select">Select Current Class:</label>
                <select id="current_class_select" class="form-control">
                    <option value="">Select a class</option>
                    <?php foreach ($classes as $class) { ?>
                        <option value="<?= $class['id'] ?>"><?= $class['name'] ?></option>
                    <?php } ?>
                </select>
            </div>

            <!-- Target Class Selection Dropdown -->
            <div class="form-group">
                <label for="target_class_select">Select Target Class:</label>
                <select id="target_class_select" class="form-control">
                    <option value="">Select a class</option>
                    <?php foreach ($classes as $class) { ?>
                        <option value="<?= $class['id'] ?>"><?= $class['name'] ?></option>
                    <?php } ?>
                </select>
            </div>

            <!-- Students Table -->
            <div id="students_table" style="display:none;">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Admission No</th>
                            <th>Class</th>
                         
                        </tr>
                    </thead>
                    <tbody id="student_list"></tbody>
                </table>
            </div>

            <!-- Button to promote all students -->
            <div>
                <button class="btn btn-success" onclick="promoteAll()">Promote All Students</button>
            </div>

            <!-- Loading Spinner (Hidden by default) -->
            <div id="loading" style="display:none; text-align:center; margin-top: 20px;">
                <div class="spinner-border" role="status">
                    <span class="sr-only">Loading...</span>
                </div>
                <p>Promoting students... Please wait.</p>
            </div>

        </div>
    </section>
</div>

<!-- AdminLTE JS -->
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

<script>
    function loadStudents() {
        var currentClassId = $('#current_class_select').val();

        if (currentClassId) {
            $.ajax({
                url: 'load_students.php',
                method: 'GET',
                data: { class_id: currentClassId },
                success: function(response) {
                    var data = JSON.parse(response);
                    var tableHtml = '';

                    if (data.students.length > 0) {
                        $('#students_table').show();

                        data.students.forEach(function(student, index) {
                            tableHtml += '<tr>';
                            tableHtml += '<td>' + (index + 1) + '</td>';
                            tableHtml += '<td>' + student.name + '</td>';
                            tableHtml += '<td>' + student.Admission_num + '</td>';
                            tableHtml += '<td>' + student.class_name + '</td>';
                           
                            tableHtml += '</tr>';
                        });

                        $('#student_list').html(tableHtml);
                    } else {
                        $('#students_table').hide();
                        alert('No students found for this class.');
                    }
                }
            });
        } else {
            $('#students_table').hide();
        }
    }

    // Function to promote all students at once
    function promoteAll() {
        var currentClassId = $('#current_class_select').val();
        var targetClassId = $('#target_class_select').val();

        if (currentClassId && targetClassId) {
            // Show the loading spinner and hide the button
            $('#loading').show();
            $('button').prop('disabled', true);

            $.ajax({
                url: 'promote_all_students.php',
                method: 'POST',
                data: {
                    current_class_id: currentClassId,
                    target_class_id: targetClassId
                },
                success: function(response) {
                    // Hide the loading spinner and enable the button
                    $('#loading').hide();
                    $('button').prop('disabled', false);

                    alert(response);  // Show the success message or any error
                    loadStudents();  // Optionally reload students to see updated data
                },
                error: function() {
                    // In case of error, hide loading and re-enable button
                    $('#loading').hide();
                    $('button').prop('disabled', false);
                    alert('An error occurred while promoting students.');
                }
            });
        } else {
            alert('Please select both the current and target classes.');
        }
    }

    // Load students when current class is selected
    $('#current_class_select').on('change', function() {
        loadStudents();
    });
</script>





								</div>
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2024. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>
