<?php
// promote_all_students.php
require_once 'includes/config.php';

$current_class_id = isset($_POST['current_class_id']) ? (int) $_POST['current_class_id'] : 0;
$target_class_id = isset($_POST['target_class_id']) ? (int) $_POST['target_class_id'] : 0;

if ($current_class_id && $target_class_id) {
    // Update all students in the current class to the target class
    $query = "UPDATE students SET class_id = :target_class_id WHERE class_id = :current_class_id";
    $stmt = $dbh->prepare($query);
    $stmt->bindParam(':target_class_id', $target_class_id, PDO::PARAM_INT);
    $stmt->bindParam(':current_class_id', $current_class_id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo "All students promoted successfully!";
    } else {
        echo "Failed to promote students.";
    }
} else {
    echo "Invalid class selection.";
}
?>
