<?php 
include('includes/config.php');
include('includes/user_data.php'); // ensures $class is available
?>

<?php
// fetch class name
$class_name = "";
if (!empty($class)) {
    $stmt = $dbh->prepare("SELECT name FROM classes WHERE id = :id");
    $stmt->bindParam(':id', $class, PDO::PARAM_INT);
    $stmt->execute();
    $cls = $stmt->fetch(PDO::FETCH_ASSOC);
    $class_name = $cls ? $cls['name'] : "";
}

// handle search
$search = isset($_GET['search']) ? trim($_GET['search']) : "";

$sql = "SELECT * FROM students WHERE class_id = :class_id AND status = 1"; // show only active students
if (!empty($search)) {
    $sql .= " AND (name LIKE :search OR Admission_num LIKE :search)";
}
$sql .= " ORDER BY id DESC";

$stmt = $dbh->prepare($sql);
$stmt->bindParam(':class_id', $class, PDO::PARAM_INT);
if (!empty($search)) {
    $searchParam = "%$search%";
    $stmt->bindParam(':search', $searchParam, PDO::PARAM_STR);
}
$stmt->execute();
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />
	<title>View Students - dominion</title>
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
</head>
<body>
<div class="wrapper">
	<?php include 'includes/side.php'; ?>
	<?php include 'includes/head.php'; ?>

	<div class="page-wrapper">
		<div class="container mt-5">
			<div class="card shadow-lg rounded-3">
				<div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
					<h5>Students in <?php echo htmlentities($class_name); ?></h5>
					<form class="d-flex" method="get">
						<input type="text" name="search" class="form-control me-2" placeholder="Search by name/admission no" value="<?php echo htmlentities($search); ?>">
						<button class="btn btn-light" type="submit">Search</button>
					</form>
				</div>
				<div class="card-body">
					<div class="table-responsive">
						<table class="table table-bordered table-hover align-middle">
							<thead class="table-light">
								<tr>
									<th>Image</th>
									<th>Admission No</th>
									<th>Name</th>
									<th>Sex</th>
									<th>DOB</th>
									<th>Parent</th>
									<th>Phone</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<?php if ($students): ?>
									<?php foreach ($students as $st): ?>
									<tr>
										<td><img src="<?php echo htmlentities($st['image']); ?>" width="50" class="rounded-circle"></td>
										<td><?php echo htmlentities($st['Admission_num']); ?></td>
										<td><?php echo htmlentities($st['name']); ?></td>
										<td><?php echo htmlentities($st['sex']); ?></td>
										<td><?php echo htmlentities($st['dob']); ?></td>
										<td><?php echo htmlentities($st['parent_name']); ?></td>
										<td><?php echo htmlentities($st['parent_phone']); ?></td>
										<td>
											<a href="edit_student.php?id=<?php echo $st['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
										</td>
									</tr>
									<?php endforeach; ?>
								<?php else: ?>
									<tr><td colspan="8" class="text-center text-muted">No active students found.</td></tr>
								<?php endif; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>
</html>
